/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import tschipp.carryon.common.helper.InvalidConfigException;
import tschipp.carryon.common.helper.StringParser;

public class ScriptParseHelper {
    public static boolean matches(double number, String cond) {
        if (cond == null || cond.isEmpty()) {
            return true;
        }
        try {
            if (cond.contains("<=")) {
                return number <= Double.parseDouble(cond.replace("<=", ""));
            }
            if (cond.contains(">=")) {
                return number >= Double.parseDouble(cond.replace(">=", ""));
            }
            if (cond.contains("<")) {
                return number < Double.parseDouble(cond.replace("<", ""));
            }
            if (cond.contains(">")) {
                return number > Double.parseDouble(cond.replace(">", ""));
            }
            if (cond.contains("=")) {
                return number == Double.parseDouble(cond.replace("=", ""));
            }
            return number == Double.parseDouble(cond);
        }
        catch (Exception e) {
            new InvalidConfigException(e.getMessage()).printException();
            return false;
        }
    }

    public static boolean matches(Block block, String cond) {
        if (cond == null || cond.isEmpty()) {
            return true;
        }
        Block toCheck = StringParser.getBlock(cond);
        if (toCheck != null) {
            return block == toCheck;
        }
        return false;
    }

    public static boolean matches(CompoundTag toCheck, CompoundTag toMatch) {
        if (toCheck == null || toMatch == null || toMatch.m_128456_()) {
            return true;
        }
        boolean matching = true;
        for (String key : toMatch.m_128431_()) {
            Tag tagToCheck;
            Tag tag = toMatch.m_128423_(key);
            if (tag.equals(tagToCheck = toCheck.m_128423_(key = key.replace("\"", "")))) continue;
            matching = false;
        }
        return matching;
    }

    public static float[] getXYZArray(String s) {
        float[] d = new float[]{ScriptParseHelper.getValueFromString(s, "x"), ScriptParseHelper.getValueFromString(s, "y"), ScriptParseHelper.getValueFromString(s, "z")};
        return d;
    }

    public static float[] getScaled(String s) {
        float[] d = new float[]{ScriptParseHelper.getScaledValueFromString(s, "x"), ScriptParseHelper.getScaledValueFromString(s, "y"), ScriptParseHelper.getScaledValueFromString(s, "z")};
        return d;
    }

    public static float getScaledValueFromString(String toGetFrom, String key) {
        String[] s;
        if (toGetFrom == null || toGetFrom.isEmpty()) {
            return 1.0f;
        }
        for (String string : s = toGetFrom.split(",")) {
            if (!string.contains(key) || !string.contains("=")) continue;
            float numb = 1.0f;
            string = string.replace(key + "=", "");
            try {
                numb = Float.parseFloat(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return numb;
        }
        return 1.0f;
    }

    public static boolean matchesScore(Player player, String cond) {
        Score sc;
        if (cond == null || cond.isEmpty()) {
            return true;
        }
        Scoreboard score = player.m_36329_();
        int iE = cond.indexOf("=");
        int iG = cond.indexOf(">");
        int iL = cond.indexOf("<");
        String numb = iG == -1 || iE < iG && iL == -1 || iE < iL && iE != -1 ? cond.substring(iE) : (iE == -1 || iG < iE && iL == -1 || iG < iL && iG != -1 ? cond.substring(iG) : cond.substring(iL));
        String scorename = cond.replace(numb, "");
        Map o = score.m_83483_(player.m_36316_().getName());
        if (o != null && (sc = (Score)o.get(score.m_83477_(scorename))) != null) {
            int points = sc.m_83400_();
            return ScriptParseHelper.matches(points, numb);
        }
        return false;
    }

    public static boolean matches(BlockPos pos, String cond) {
        if (cond == null || cond.isEmpty()) {
            return true;
        }
        BlockPos blockpos = new BlockPos((double)ScriptParseHelper.getValueFromString(cond, "x"), (double)ScriptParseHelper.getValueFromString(cond, "y"), (double)ScriptParseHelper.getValueFromString(cond, "z"));
        BlockPos expand = new BlockPos((double)ScriptParseHelper.getValueFromString(cond, "dx"), (double)ScriptParseHelper.getValueFromString(cond, "dy"), (double)ScriptParseHelper.getValueFromString(cond, "dz"));
        BlockPos expanded = blockpos.m_141952_((Vec3i)expand);
        boolean x = pos.m_123341_() >= blockpos.m_123341_() && pos.m_123341_() <= expanded.m_123341_() || blockpos.m_123341_() == 0;
        boolean y = pos.m_123342_() >= blockpos.m_123342_() && pos.m_123342_() <= expanded.m_123342_() || blockpos.m_123342_() == 0;
        boolean z = pos.m_123343_() >= blockpos.m_123343_() && pos.m_123343_() <= expanded.m_123343_() || blockpos.m_123343_() == 0;
        return x && y && z;
    }

    public static float getValueFromString(String toGetFrom, String key) {
        String[] s;
        if (toGetFrom == null || toGetFrom.isEmpty()) {
            return 0.0f;
        }
        for (String string : s = toGetFrom.split(",")) {
            if (!string.contains(key) || !string.contains("=")) continue;
            float numb = 0.0f;
            string = string.replace(key + "=", "");
            try {
                numb = Float.parseFloat(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return numb;
        }
        return 0.0f;
    }

    public static boolean hasEffects(Player player, String cond) {
        int lev;
        if (cond == null || cond.isEmpty()) {
            return true;
        }
        Collection effects = player.m_21220_();
        String[] potions = cond.split(",");
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Integer> levels = new ArrayList<Integer>();
        for (String pot : potions) {
            if (pot.contains("#")) {
                String level = pot.substring(pot.indexOf("#"));
                String name = pot.substring(0, pot.indexOf("#"));
                level = level.replace("#", "");
                lev = 0;
                try {
                    lev = Integer.parseInt(level);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                levels.add(lev);
                names.add(name);
                continue;
            }
            levels.add(0);
            names.add(pot);
        }
        int matches = 0;
        for (MobEffectInstance effect : effects) {
            int idx;
            int amp = effect.m_19564_();
            String name = effect.m_19544_().getRegistryName().toString();
            if (!names.contains(name) || (lev = ((Integer)levels.get(idx = names.indexOf(name))).intValue()) != amp) continue;
            ++matches;
        }
        return matches == potions.length;
    }

    public static boolean matches(Material material, String cond) {
        if (cond == null || cond.isEmpty()) {
            return true;
        }
        switch (cond) {
            case "air": {
                return material == Material.f_76296_;
            }
            case "anvil": {
                return material == Material.f_76281_;
            }
            case "barrier": {
                return material == Material.f_76282_;
            }
            case "cactus": {
                return material == Material.f_76277_;
            }
            case "cake": {
                return material == Material.f_76287_;
            }
            case "carpet": {
                return material == Material.f_76299_;
            }
            case "clay": {
                return material == Material.f_76313_;
            }
            case "cloth": {
                return material == Material.f_76272_;
            }
            case "dragon_egg": {
                return material == Material.f_76286_;
            }
            case "fire": {
                return material == Material.f_76309_;
            }
            case "glass": {
                return material == Material.f_76275_;
            }
            case "gourd": {
                return material == Material.f_76285_;
            }
            case "grass": {
                return material == Material.f_76315_;
            }
            case "ground": {
                return material == Material.f_76315_;
            }
            case "ice": {
                return material == Material.f_76276_;
            }
            case "iron": {
                return material == Material.f_76279_;
            }
            case "lava": {
                return material == Material.f_76307_;
            }
            case "leaves": {
                return material == Material.f_76274_;
            }
            case "packed_ice": {
                return material == Material.f_76316_;
            }
            case "piston": {
                return material == Material.f_76283_;
            }
            case "plants": {
                return material == Material.f_76300_;
            }
            case "portal": {
                return material == Material.f_76298_;
            }
            case "redstone_light": {
                return material == Material.f_76312_;
            }
            case "rock": {
                return material == Material.f_76278_;
            }
            case "sand": {
                return material == Material.f_76317_;
            }
            case "snow": {
                return material == Material.f_76308_;
            }
            case "sponge": {
                return material == Material.f_76318_;
            }
            case "structure_void": {
                return material == Material.f_76297_;
            }
            case "tnt": {
                return material == Material.f_76273_;
            }
            case "vine": {
                return material == Material.f_76300_;
            }
            case "water": {
                return material == Material.f_76305_;
            }
            case "web": {
                return material == Material.f_76311_;
            }
            case "wood": {
                return material == Material.f_76320_;
            }
        }
        return false;
    }
}

